/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.Board;
import GUI.ViewComponents;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import jovolog.Jovolog;
import jovolog.model.JovologEngineController;
import jovolog.model.JovologEngineException;
import jovolog.model.Model;
import jovolog.utils.ExceptionHandler;

public class MainViewController
implements ActionListener {
    private JovologEngineController engineController = new JovologEngineController(this);
    private boolean engineRunning = false;
    private JFrame parent;
    private Model model;
    private ViewComponents c;

    void init(JFrame parent, Model model, ViewComponents c) {
        this.parent = parent;
        this.model = model;
        this.c = c;
        this.engineController.setEngine(this.model.engine);
        this.resetDisplay();
    }

    void updateSelectedWorld() {
        try {
            if (this.c.listAvailableWorlds.isSelectionEmpty()) {
                return;
            }
            String selectedWorldName = this.c.listAvailableWorlds.getSelectedValue().toString();
            this.engineController.purgeWorld();
            this.engineController.loadWorld(this.model.worldRegister.getSource(selectedWorldName));
            this.c.labelLoadedWorld.setText(selectedWorldName);
            this.c.worldParameters.setText(this.engineController.getDefaultWorldParameters());
            if (this.engineController.engineReady()) {
                this.reset();
            }
        }
        catch (JovologEngineException ex) {
            this.c.listAvailableWorlds.clearSelection();
            ExceptionHandler.handle(ex, this.parent);
        }
    }

    void updateSelectedPlayer() {
        try {
            if (this.c.listAvailablePlayers.isSelectionEmpty()) {
                return;
            }
            boolean engineWasReady = this.engineController.engineReady();
            String selectedPlayerName = this.c.listAvailablePlayers.getSelectedValue().toString();
            this.engineController.loadPlayer(this.model.playerRegister.getSource(selectedPlayerName));
            this.c.labelLoadedPlayer.setText(selectedPlayerName);
            if (!engineWasReady && this.engineController.engineReady()) {
                this.reset();
            }
        }
        catch (JovologEngineException ex) {
            this.c.listAvailablePlayers.clearSelection();
            ExceptionHandler.handle(ex, this.parent);
        }
    }

    private void resetDisplay() {
        this.c.listAvailableWorlds.setModel(this.model.worldRegister.getAllSourcesAsListModel());
        this.c.listAvailablePlayers.setModel(this.model.playerRegister.getAllSourcesAsListModel());
        this.c.boardPanel.clearBoard();
        this.c.playerActionPredicate.setText("");
        this.c.gameStatusPredicate.setText("");
        this.c.worldPredicates.setText("");
        this.c.playerPerceptsPredicates.setText("");
        this.c.playerKnowledgePredicates.setText("");
        this.c.worldParameters.setText("");
        this.disableControlPanel();
    }

    void startPause() {
        if (this.engineRunning) {
            this.pause();
        } else {
            this.run();
        }
    }

    void step() {
        this.step(1);
    }

    private void step(int stepSize) {
        try {
            this.engineController.step(stepSize);
            if (!this.engineController.getGameStatusMessage().equals("")) {
                this.c.gameLog.append(String.format("Step %4d: %s\n", this.engineController.getCurrentStep(), this.engineController.getGameStatusMessage()));
            }
            if (this.engineController.gameEnded()) {
                this.gameEnded();
            }
            this.updateDisplay();
        }
        catch (JovologEngineException ex) {
            ExceptionHandler.handle(ex, this.parent);
        }
    }

    private void gameEnded() {
        this.pause();
        this.disallowStepping();
        this.c.gameLog.append(String.format("Game ended. Total steps: %4d Final points: %d\n", this.engineController.getCurrentStep(), this.engineController.getPoints()));
    }

    private void updateDisplay() {
        this.updatePredicatesDisplay();
        this.updateBoardDisplay();
        this.c.labelCurrentStep.setText(String.valueOf(this.engineController.getCurrentStep()));
        this.c.labelCurrentPlayerPoints.setText(String.valueOf(this.engineController.getPoints()));
    }

    void reset() {
        try {
            this.engineController.reset();
            this.updateDisplay();
            this.c.gameLog.append("Game reseted.\n");
            this.allowStepping();
        }
        catch (JovologEngineException ex) {
            ExceptionHandler.handle(ex, this.parent);
        }
    }

    void multistepWithLimit() {
        try {
            int stepLimit = (Integer)this.c.spinnerStepLimit.getValue();
            this.engineController.multistepWithLimit(stepLimit);
            this.updateDisplay();
            if (this.engineController.gameEnded()) {
                this.gameEnded();
            }
        }
        catch (JovologEngineException ex) {
            ExceptionHandler.handle(ex, this.parent);
        }
    }

    void reload() {
        Jovolog.getApplication().loadPrologSources();
        this.engineController.purge();
        this.resetDisplay();
    }

    void clearLog() {
        this.c.gameLog.setText("");
    }

    void generateWorld() {
        try {
            this.engineController.generateWorld(this.c.worldParameters.getText());
            this.c.gameLog.append("World regenerated.\n");
            this.reset();
        }
        catch (JovologEngineException ex) {
            ExceptionHandler.handle(ex, this.parent);
        }
    }

    private void pause() {
        this.engineController.pause();
        this.engineRunning = false;
        this.c.buttonResetSimulation.setEnabled(true);
        this.c.buttonResetWorld.setEnabled(true);
        this.c.buttonMultistepWithLimit.setEnabled(true);
        this.c.buttonStep.setEnabled(true);
        this.c.buttonReload.setEnabled(true);
        this.c.listAvailablePlayers.setEnabled(true);
        this.c.listAvailableWorlds.setEnabled(true);
    }

    private void run() {
        this.engineRunning = true;
        this.engineController.start(this.c.sliderGameSpeed.getValue());
        this.c.buttonResetSimulation.setEnabled(false);
        this.c.buttonResetWorld.setEnabled(false);
        this.c.buttonMultistepWithLimit.setEnabled(false);
        this.c.buttonStep.setEnabled(false);
        this.c.buttonReload.setEnabled(false);
        this.c.listAvailablePlayers.setEnabled(false);
        this.c.listAvailableWorlds.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        this.step(1);
    }

    private void disableControlPanel() {
        this.c.buttonStartPause.setEnabled(false);
        this.c.buttonResetSimulation.setEnabled(false);
        this.c.buttonResetWorld.setEnabled(false);
        this.c.buttonMultistepWithLimit.setEnabled(false);
        this.c.buttonStep.setEnabled(false);
    }

    private void disallowStepping() {
        this.c.buttonStep.setEnabled(false);
        this.c.buttonMultistepWithLimit.setEnabled(false);
        this.c.buttonStartPause.setEnabled(false);
    }

    private void updatePredicatesDisplay() {
        this.c.playerActionPredicate.setText(this.engineController.getPlayerActionPredicate());
        this.c.gameStatusPredicate.setText(this.engineController.getGameStatusPredicate());
        this.c.worldPredicates.setText(this.engineController.getWorldPredicates());
        this.c.playerPerceptsPredicates.setText(this.engineController.getPlayerPerceptsPredicates());
        this.c.playerKnowledgePredicates.setText(this.engineController.getPlayerKnowledgePredicates());
    }

    private void allowStepping() {
        this.c.buttonStep.setEnabled(true);
        this.c.buttonMultistepWithLimit.setEnabled(true);
        this.c.buttonStartPause.setEnabled(true);
        this.c.buttonResetWorld.setEnabled(true);
        this.c.buttonResetSimulation.setEnabled(true);
    }

    private void updateBoardDisplay() {
        Board board = this.engineController.getBoardDisplay();
        this.c.boardPanel.setBoard(board);
    }

    void loadWorld() {
        File worldFile = this.model.ioManager.chooseFile("prolog");
        if (worldFile != null) {
            try {
                this.model.worldRegister.loadSource(worldFile);
                DefaultListModel dlm = (DefaultListModel)this.c.listAvailableWorlds.getModel();
                dlm.addElement(this.model.worldRegister.getSource(worldFile.getName()));
            }
            catch (IOException ex) {
                ExceptionHandler.handleNoStack(ex, null, "Couldn't load prolog source.\n\nCause:\n" + ex);
            }
        }
    }

    void loadPlayer() {
        File playerFile = this.model.ioManager.chooseFile("prolog");
        if (playerFile != null) {
            try {
                this.model.playerRegister.loadSource(playerFile);
                DefaultListModel dlm = (DefaultListModel)this.c.listAvailablePlayers.getModel();
                dlm.addElement(this.model.playerRegister.getSource(playerFile.getName()));
            }
            catch (IOException ex) {
                ExceptionHandler.handleNoStack(ex, null, "Couldn't load prolog source.\n\nCause:\n" + ex);
            }
        }
    }
}

