/*
 * Decompiled with CFR 0.152.
 */
package jovolog.model;

import alice.tuprolog.Theory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;
import jovolog.model.Model;
import jovolog.model.PrologSource;

public class PrologSourceRegister {
    private Map<String, PrologSource> prologSources = new HashMap<String, PrologSource>();
    private Model model;

    public PrologSourceRegister(Model model) {
        this.model = model;
    }

    public void loadSource(File sourceFile) throws IOException {
        PrologSource source = new PrologSource();
        Theory theory = this.model.ioManager.getTheory(sourceFile);
        source.setFileName(sourceFile.getName());
        source.setTheory(theory);
        this.prologSources.put(source.getFileName(), source);
    }

    public PrologSource getSource(String fileName) {
        return this.prologSources.get(fileName);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("PrologSourceRegister:\n");
        for (PrologSource source : this.prologSources.values()) {
            stringBuilder.append(source);
        }
        return stringBuilder.toString();
    }

    public ListModel getAllSourcesAsListModel() {
        DefaultListModel<PrologSource> model = new DefaultListModel<PrologSource>();
        for (PrologSource source : this.prologSources.values()) {
            model.addElement(source);
        }
        return model;
    }

    public void loadSources(File[] playersSources) throws IOException {
        for (File file : playersSources) {
            this.loadSource(file);
        }
    }

    public void clear() {
        this.prologSources.clear();
    }
}

