/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprolog;

import alice.tuprolog.DefaultOperatorManager;
import alice.tuprolog.Double;
import alice.tuprolog.Int;
import alice.tuprolog.InvalidTermException;
import alice.tuprolog.Long;
import alice.tuprolog.Number;
import alice.tuprolog.OperatorManager;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import alice.tuprolog.TermIterator;
import alice.tuprolog.Token;
import alice.tuprolog.Tokenizer;
import alice.tuprolog.Var;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class Parser
implements Serializable {
    private static OperatorManager defaultOperatorManager = new DefaultOperatorManager();
    private Tokenizer tokenizer;
    private OperatorManager opManager = defaultOperatorManager;
    private static Pattern atom = Pattern.compile("(!|[a-z][a-zA-Z_0-9]*)");

    public Parser(OperatorManager operatorManager, InputStream inputStream) {
        this(inputStream);
        if (operatorManager != null) {
            this.opManager = operatorManager;
        }
    }

    public Parser(OperatorManager operatorManager, String string) {
        this(string);
        if (operatorManager != null) {
            this.opManager = operatorManager;
        }
    }

    public Parser(String string) {
        this.tokenizer = new Tokenizer(string);
    }

    public Parser(InputStream inputStream) {
        this.tokenizer = new Tokenizer(new BufferedReader(new InputStreamReader(inputStream)));
    }

    public Iterator iterator() {
        return new TermIterator(this);
    }

    public Term nextTerm(boolean bl) throws InvalidTermException {
        try {
            Token token = this.tokenizer.readToken();
            if (token.isEOF()) {
                return null;
            }
            this.tokenizer.unreadToken(token);
            Term term = this.expr(false);
            if (term == null) {
                throw new InvalidTermException("The parser is unable to finish.");
            }
            if (bl && this.tokenizer.readToken().getType() != 13) {
                throw new InvalidTermException("The term " + term + " is not ended with a period.");
            }
            term.resolveTerm();
            return term;
        }
        catch (IOException iOException) {
            throw new InvalidTermException("An I/O error occured.");
        }
    }

    public static Term parseSingleTerm(String string) throws InvalidTermException {
        return Parser.parseSingleTerm(string, null);
    }

    public static Term parseSingleTerm(String string, OperatorManager operatorManager) throws InvalidTermException {
        try {
            Parser parser = new Parser(operatorManager, string);
            Token token = parser.tokenizer.readToken();
            if (token.isEOF()) {
                throw new InvalidTermException("Term starts with EOF");
            }
            parser.tokenizer.unreadToken(token);
            Term term = parser.expr(false);
            if (term == null) {
                throw new InvalidTermException("Term is null");
            }
            if (!parser.tokenizer.readToken().isEOF()) {
                throw new InvalidTermException("The enitire string could not be read as one term");
            }
            term.resolveTerm();
            return term;
        }
        catch (IOException iOException) {
            throw new InvalidTermException("An I/O error occured");
        }
    }

    private Term expr(boolean bl) throws InvalidTermException, IOException {
        return this.exprA(1200, bl).result;
    }

    private IdentifiedTerm exprA(int n, boolean bl) throws InvalidTermException, IOException {
        IdentifiedTerm identifiedTerm = this.exprB(n, bl);
        Token token = this.tokenizer.readToken();
        while (token.isOperator(bl)) {
            IdentifiedTerm identifiedTerm2;
            int n2 = this.opManager.opPrio(token.seq, "yfx");
            int n3 = this.opManager.opPrio(token.seq, "yf");
            if (n3 < identifiedTerm.priority || n3 > n) {
                n3 = -1;
            }
            if (n2 < identifiedTerm.priority || n2 > n) {
                n2 = -1;
            }
            if (n2 >= n3 && n2 >= 1 && (identifiedTerm2 = this.exprA(n2 - 1, bl)) != null) {
                identifiedTerm = new IdentifiedTerm(n2, new Struct(token.seq, identifiedTerm.result, identifiedTerm2.result));
            } else {
                if (n3 < 1) break;
                identifiedTerm = new IdentifiedTerm(n3, new Struct(token.seq, identifiedTerm.result));
            }
            token = this.tokenizer.readToken();
        }
        this.tokenizer.unreadToken(token);
        return identifiedTerm;
    }

    /*
     * Unable to fully structure code
     */
    private IdentifiedTerm exprB(int var1_1, boolean var2_2) throws InvalidTermException, IOException {
        var3_3 = this.parseLeftSide(var2_2, var1_1);
        var4_4 = this.tokenizer.readToken();
        while (var4_4.isOperator(var2_2)) {
            var5_5 = this.opManager.opPrio(var4_4.seq, "xfx");
            var6_6 = this.opManager.opPrio(var4_4.seq, "xfy");
            var7_7 = this.opManager.opPrio(var4_4.seq, "xf");
            if (var5_5 > var1_1 || var5_5 < 1) {
                var5_5 = -1;
            }
            if (var6_6 > var1_1 || var6_6 < 1) {
                var6_6 = -1;
            }
            if (var7_7 > var1_1 || var7_7 < 1) {
                var7_7 = -1;
            }
            var8_8 = false;
            if (var5_5 < var6_6 || var5_5 < var7_7 || var5_5 < IdentifiedTerm.access$100(var3_3)) ** GOTO lbl21
            var9_9 = this.exprA(var5_5 - 1, var2_2);
            if (var9_9 != null) {
                var10_10 = new Struct(var4_4.seq, IdentifiedTerm.access$000(var3_3), IdentifiedTerm.access$000(var9_9));
                var3_3 = new IdentifiedTerm(var5_5, var10_10);
            } else {
                var8_8 = true;
lbl21:
                // 2 sources

                if (var6_6 >= var7_7 && var6_6 >= IdentifiedTerm.access$100(var3_3) && (var9_9 = this.exprA(var6_6, var2_2)) != null) {
                    var10_10 = new Struct(var4_4.seq, IdentifiedTerm.access$000(var3_3), IdentifiedTerm.access$000(var9_9));
                    var3_3 = new IdentifiedTerm(var6_6, var10_10);
                } else {
                    if (var7_7 >= IdentifiedTerm.access$100(var3_3)) {
                        return new IdentifiedTerm(var7_7, new Struct(var4_4.seq, IdentifiedTerm.access$000(var3_3)));
                    }
                    if (var8_8 || var5_5 < IdentifiedTerm.access$100(var3_3) || (var9_9 = this.exprA(var5_5 - 1, var2_2)) == null) break;
                    var10_10 = new Struct(var4_4.seq, IdentifiedTerm.access$000(var3_3), IdentifiedTerm.access$000(var9_9));
                    var3_3 = new IdentifiedTerm(var5_5, var10_10);
                }
            }
            var4_4 = this.tokenizer.readToken();
        }
        this.tokenizer.unreadToken(var4_4);
        return var3_3;
    }

    private IdentifiedTerm parseLeftSide(boolean bl, int n) throws InvalidTermException, IOException {
        Token token = this.tokenizer.readToken();
        if (token.isOperator(bl)) {
            IdentifiedTerm identifiedTerm;
            int n2 = this.opManager.opPrio(token.seq, "fx");
            int n3 = this.opManager.opPrio(token.seq, "fy");
            if (token.seq.equals("-")) {
                Token token2 = this.tokenizer.readToken();
                if (token2.isNumber()) {
                    return new IdentifiedTerm(0, Parser.createNumber("-" + token2.seq));
                }
                this.tokenizer.unreadToken(token2);
            }
            if (n3 > n) {
                n3 = -1;
            }
            if (n2 > n) {
                n2 = -1;
            }
            boolean bl2 = false;
            if (n2 >= n3 && n2 >= 1) {
                identifiedTerm = this.exprA(n2 - 1, bl);
                if (identifiedTerm != null) {
                    return new IdentifiedTerm(n2, new Struct(token.seq, identifiedTerm.result));
                }
                bl2 = true;
            }
            if (n3 >= 1 && (identifiedTerm = this.exprA(n3, bl)) != null) {
                return new IdentifiedTerm(n3, new Struct(token.seq, identifiedTerm.result));
            }
            if (!bl2 && n2 >= 1 && (identifiedTerm = this.exprA(n2 - 1, bl)) != null) {
                return new IdentifiedTerm(n2, new Struct(token.seq, identifiedTerm.result));
            }
        }
        this.tokenizer.unreadToken(token);
        return new IdentifiedTerm(0, this.expr0());
    }

    private Term expr0() throws InvalidTermException, IOException {
        Token token = this.tokenizer.readToken();
        if (token.isType(6)) {
            return Parser.parseInteger(token.seq);
        }
        if (token.isType(7)) {
            return Parser.parseFloat(token.seq);
        }
        if (token.isType(9)) {
            return new Var(token.seq);
        }
        if (token.isType(8) || token.isType(10) || token.isType(11)) {
            if (!token.isFunctor()) {
                return new Struct(token.seq);
            }
            String string = token.seq;
            Token token2 = this.tokenizer.readToken();
            if (!token2.isType(1)) {
                throw new InvalidTermException("bug in parsing process. Something identified as functor misses its first left parenthesis");
            }
            LinkedList linkedList = this.expr0_arglist();
            Token token3 = this.tokenizer.readToken();
            if (token3.isType(2)) {
                return new Struct(string, linkedList);
            }
            throw new InvalidTermException("Missing right parenthesis: (" + linkedList + " -> here <-");
        }
        if (token.isType(1)) {
            Term term = this.expr(false);
            if (this.tokenizer.readToken().isType(2)) {
                return term;
            }
            throw new InvalidTermException("Missing right parenthesis: (" + term + " -> here <-");
        }
        if (token.isType(3)) {
            Token token4 = this.tokenizer.readToken();
            if (token4.isType(4)) {
                return new Struct();
            }
            this.tokenizer.unreadToken(token4);
            Term term = this.expr0_list();
            if (this.tokenizer.readToken().isType(4)) {
                return term;
            }
            throw new InvalidTermException("Missing right bracket: [" + term + " -> here <-");
        }
        if (token.isType(14)) {
            Token token5 = this.tokenizer.readToken();
            if (token5.isType(15)) {
                return new Struct("{}");
            }
            this.tokenizer.unreadToken(token5);
            Term term = this.expr(false);
            token5 = this.tokenizer.readToken();
            if (token5.isType(15)) {
                return new Struct("{}", term);
            }
            throw new InvalidTermException("Missing right braces: {" + term + " -> here <-");
        }
        throw new InvalidTermException("The following token could not be identified: " + token.seq);
    }

    private Term expr0_list() throws InvalidTermException, IOException {
        Term term = this.expr(true);
        Token token = this.tokenizer.readToken();
        if (",".equals(token.seq)) {
            return new Struct(term, this.expr0_list());
        }
        if ("|".equals(token.seq)) {
            return new Struct(term, this.expr(true));
        }
        if ("]".equals(token.seq)) {
            this.tokenizer.unreadToken(token);
            return new Struct(term, (Term)new Struct());
        }
        throw new InvalidTermException("The expression: " + term + "\nis not followed by either a ',' or '|'  or ']'.");
    }

    private LinkedList expr0_arglist() throws InvalidTermException, IOException {
        Term term = this.expr(true);
        Token token = this.tokenizer.readToken();
        if (",".equals(token.seq)) {
            LinkedList linkedList = this.expr0_arglist();
            linkedList.addFirst(term);
            return linkedList;
        }
        if (")".equals(token.seq)) {
            this.tokenizer.unreadToken(token);
            LinkedList<Term> linkedList = new LinkedList<Term>();
            linkedList.add(term);
            return linkedList;
        }
        throw new InvalidTermException("The argument: " + term + "\nis not followed by either a ',' or ')'.\nline: " + this.tokenizer.lineno());
    }

    static Number parseInteger(String string) {
        long l = java.lang.Long.parseLong(string);
        if (l > Integer.MIN_VALUE && l < Integer.MAX_VALUE) {
            return new Int((int)l);
        }
        return new Long(l);
    }

    static Double parseFloat(String string) {
        double d = java.lang.Double.parseDouble(string);
        return new Double(d);
    }

    static Number createNumber(String string) {
        try {
            return Parser.parseInteger(string);
        }
        catch (Exception exception) {
            return Parser.parseFloat(string);
        }
    }

    public int getCurrentLine() {
        return this.tokenizer.lineno();
    }

    public static boolean isAtom(String string) {
        return atom.matcher(string).matches();
    }

    private static class IdentifiedTerm {
        private int priority;
        private Term result;

        public IdentifiedTerm(int n, Term term) {
            this.priority = n;
            this.result = term;
        }
    }
}

