/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.util.jedit.KeywordMap;
import alice.util.jedit.TokenMarker;
import javax.swing.text.Segment;

public class PrologTokenMarker
extends TokenMarker {
    private static KeywordMap libraryKeywords;
    private boolean cpp;
    private KeywordMap keywords;
    private int lastOffset;
    private int lastKeyword;

    public PrologTokenMarker() {
        this(true, PrologTokenMarker.getKeywords());
    }

    public PrologTokenMarker(boolean bl, KeywordMap keywordMap) {
        this.cpp = bl;
        this.keywords = keywordMap;
    }

    public byte markTokensImpl(byte by, Segment segment, int n) {
        int n2;
        char[] cArray = segment.array;
        this.lastOffset = n2 = segment.offset;
        this.lastKeyword = n2;
        int n3 = segment.count + n2;
        boolean bl = false;
        block20: for (int i = n2; i < n3; ++i) {
            int n4 = i + 1;
            char c = cArray[i];
            if (c == '\\') {
                bl = !bl;
                continue;
            }
            switch (by) {
                case 0: {
                    block6 : switch (c) {
                        case '%': {
                            if (bl) {
                                bl = false;
                            }
                            this.doKeyword(segment, i, c);
                            this.addToken(i - this.lastOffset, by);
                            this.addToken(n3 - i, (byte)1);
                            this.lastOffset = this.lastKeyword = n3;
                            break block20;
                        }
                        case '\"': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '[': {
                            this.doKeyword(segment, i, c);
                            if (bl) {
                                bl = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, by);
                            by = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '/': {
                            bl = false;
                            this.doKeyword(segment, i, c);
                            if (n3 - i <= 1) continue block20;
                            switch (cArray[n4]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, by);
                                    this.lastOffset = this.lastKeyword = i;
                                    if (n3 - i > 2 && cArray[i + 2] == '*') {
                                        by = (byte)2;
                                        break block6;
                                    }
                                    by = 1;
                                }
                            }
                            break;
                        }
                        default: {
                            bl = false;
                            if (Character.isLetterOrDigit(c) || c == '_' || c == '!') continue block20;
                            this.doKeyword(segment, i, c);
                            break;
                        }
                    }
                    continue block20;
                }
                case 1: 
                case 2: {
                    bl = false;
                    if (c != '*' || n3 - i <= 1 || cArray[n4] != '/') continue block20;
                    this.addToken(++i + 1 - this.lastOffset, by);
                    by = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block20;
                }
                case 3: {
                    if (bl) {
                        bl = false;
                        continue block20;
                    }
                    if (c == '\"') {
                        this.addToken(n4 - this.lastOffset, by);
                        by = 0;
                        this.lastOffset = this.lastKeyword = n4;
                        continue block20;
                    }
                    if (c != '\'') continue block20;
                    this.addToken(n4 - this.lastOffset, by);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block20;
                }
                case 4: {
                    if (bl) {
                        bl = false;
                        continue block20;
                    }
                    if (c != ']') continue block20;
                    this.addToken(n4 - this.lastOffset, (byte)4);
                    by = 0;
                    this.lastOffset = this.lastKeyword = n4;
                    continue block20;
                }
                default: {
                    throw new InternalError("Invalid state: " + by);
                }
            }
        }
        if (by == 0) {
            this.doKeyword(segment, n3, '\u0000');
        }
        switch (by) {
            case 3: 
            case 4: {
                this.addToken(n3 - this.lastOffset, (byte)10);
                by = 0;
                break;
            }
            case 7: {
                this.addToken(n3 - this.lastOffset, by);
                if (!bl) {
                    by = 0;
                }
            }
            default: {
                this.addToken(n3 - this.lastOffset, by);
            }
        }
        return by;
    }

    public static KeywordMap getKeywords() {
        if (libraryKeywords == null) {
            libraryKeywords = new KeywordMap(false);
            libraryKeywords.add("abolish", (byte)7);
            libraryKeywords.add("add_theory", (byte)7);
            libraryKeywords.add("agent", (byte)7);
            libraryKeywords.add("arg", (byte)7);
            libraryKeywords.add("append", (byte)7);
            libraryKeywords.add("assert", (byte)7);
            libraryKeywords.add("asserta", (byte)7);
            libraryKeywords.add("assertz", (byte)7);
            libraryKeywords.add("atom", (byte)7);
            libraryKeywords.add("atomic", (byte)7);
            libraryKeywords.add("bagof", (byte)7);
            libraryKeywords.add("call", (byte)7);
            libraryKeywords.add("clause", (byte)7);
            libraryKeywords.add("compound", (byte)7);
            libraryKeywords.add("constant", (byte)7);
            libraryKeywords.add("copy_term", (byte)7);
            libraryKeywords.add("current_op", (byte)7);
            libraryKeywords.add("current_prolog_flag", (byte)7);
            libraryKeywords.add("delete", (byte)7);
            libraryKeywords.add("element", (byte)7);
            libraryKeywords.add("findall", (byte)7);
            libraryKeywords.add("float", (byte)7);
            libraryKeywords.add("functor", (byte)7);
            libraryKeywords.add("get_theory", (byte)7);
            libraryKeywords.add("ground", (byte)7);
            libraryKeywords.add("integer", (byte)7);
            libraryKeywords.add("length", (byte)7);
            libraryKeywords.add("list", (byte)7);
            libraryKeywords.add("member", (byte)7);
            libraryKeywords.add("nonvar", (byte)7);
            libraryKeywords.add("nospy", (byte)6);
            libraryKeywords.add("not", (byte)7);
            libraryKeywords.add("num_atom", (byte)7);
            libraryKeywords.add("number", (byte)7);
            libraryKeywords.add("once", (byte)7);
            libraryKeywords.add("quicksort", (byte)7);
            libraryKeywords.add("repeat", (byte)6);
            libraryKeywords.add("retract", (byte)7);
            libraryKeywords.add("retract_bt", (byte)7);
            libraryKeywords.add("retract_nb", (byte)7);
            libraryKeywords.add("reverse", (byte)7);
            libraryKeywords.add("set_prolog_flag", (byte)7);
            libraryKeywords.add("set_theory", (byte)7);
            libraryKeywords.add("setof", (byte)7);
            libraryKeywords.add("spy", (byte)7);
            libraryKeywords.add("text_concat", (byte)7);
            libraryKeywords.add("text_term", (byte)7);
            libraryKeywords.add("unify_with_occurs_check", (byte)7);
            libraryKeywords.add("var", (byte)7);
            libraryKeywords.add("atom_length", (byte)7);
            libraryKeywords.add("atom_chars", (byte)7);
            libraryKeywords.add("atom_codes", (byte)7);
            libraryKeywords.add("atom_concat", (byte)7);
            libraryKeywords.add("bound", (byte)7);
            libraryKeywords.add("char_code", (byte)7);
            libraryKeywords.add("number_chars", (byte)7);
            libraryKeywords.add("number_codes", (byte)7);
            libraryKeywords.add("sub_atom", (byte)7);
            libraryKeywords.add("abs", (byte)7);
            libraryKeywords.add("atan", (byte)7);
            libraryKeywords.add("ceiling", (byte)7);
            libraryKeywords.add("cos", (byte)7);
            libraryKeywords.add("div", (byte)7);
            libraryKeywords.add("exp", (byte)7);
            libraryKeywords.add("float_fractional_part", (byte)7);
            libraryKeywords.add("float_integer_part", (byte)7);
            libraryKeywords.add("floor", (byte)7);
            libraryKeywords.add("log", (byte)7);
            libraryKeywords.add("mod", (byte)7);
            libraryKeywords.add("rem", (byte)7);
            libraryKeywords.add("round", (byte)7);
            libraryKeywords.add("sign", (byte)7);
            libraryKeywords.add("sin", (byte)7);
            libraryKeywords.add("sqrt", (byte)7);
            libraryKeywords.add("truncate", (byte)7);
            libraryKeywords.add("agent_file", (byte)7);
            libraryKeywords.add("consult", (byte)7);
            libraryKeywords.add("get", (byte)7);
            libraryKeywords.add("get0", (byte)7);
            libraryKeywords.add("nl", (byte)6);
            libraryKeywords.add("put", (byte)7);
            libraryKeywords.add("rand_float", (byte)7);
            libraryKeywords.add("rand_int", (byte)7);
            libraryKeywords.add("read", (byte)7);
            libraryKeywords.add("see", (byte)7);
            libraryKeywords.add("seeing", (byte)7);
            libraryKeywords.add("seen", (byte)6);
            libraryKeywords.add("solve_file", (byte)7);
            libraryKeywords.add("tab", (byte)7);
            libraryKeywords.add("tell", (byte)7);
            libraryKeywords.add("telling", (byte)7);
            libraryKeywords.add("text_from_file", (byte)7);
            libraryKeywords.add("told", (byte)6);
            libraryKeywords.add("write", (byte)7);
            libraryKeywords.add("as", (byte)7);
            libraryKeywords.add("destroy_object", (byte)7);
            libraryKeywords.add("java_array_get", (byte)7);
            libraryKeywords.add("java_array_get_boolean", (byte)7);
            libraryKeywords.add("java_array_get_byte", (byte)7);
            libraryKeywords.add("java_array_get_char", (byte)7);
            libraryKeywords.add("java_array_get_double", (byte)7);
            libraryKeywords.add("java_array_get_float", (byte)7);
            libraryKeywords.add("java_array_get_int", (byte)7);
            libraryKeywords.add("java_array_get_long", (byte)7);
            libraryKeywords.add("java_array_get_short", (byte)7);
            libraryKeywords.add("java_array_length", (byte)7);
            libraryKeywords.add("java_array_set", (byte)7);
            libraryKeywords.add("java_array_set_boolean", (byte)7);
            libraryKeywords.add("java_array_set_byte", (byte)7);
            libraryKeywords.add("java_array_set_char", (byte)7);
            libraryKeywords.add("java_array_set_double", (byte)7);
            libraryKeywords.add("java_array_set_float", (byte)7);
            libraryKeywords.add("java_array_set_int", (byte)7);
            libraryKeywords.add("java_array_set_long", (byte)7);
            libraryKeywords.add("java_array_set_short", (byte)7);
            libraryKeywords.add("java_call", (byte)7);
            libraryKeywords.add("java_class", (byte)7);
            libraryKeywords.add("java_object", (byte)7);
            libraryKeywords.add("java_object_bt", (byte)7);
            libraryKeywords.add("java_object_nb", (byte)7);
            libraryKeywords.add("java_object_string", (byte)7);
            libraryKeywords.add("returns", (byte)7);
            libraryKeywords.add("!", (byte)6);
            libraryKeywords.add("at_the_end_of_stream", (byte)6);
            libraryKeywords.add("fail", (byte)6);
            libraryKeywords.add("halt", (byte)6);
            libraryKeywords.add("is", (byte)6);
            libraryKeywords.add("true", (byte)6);
            libraryKeywords.add("_", (byte)8);
        }
        return libraryKeywords;
    }

    private boolean doKeyword(Segment segment, int n, char c) {
        int n2 = n + 1;
        int n3 = n - this.lastKeyword;
        byte by = this.keywords.lookup(segment, this.lastKeyword, n3);
        if (by != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(n3, by);
            this.lastOffset = n;
        }
        this.lastKeyword = n2;
        return false;
    }
}

