/*
 * Decompiled with CFR 0.152.
 */
package alice.tuprologx.ide;

import alice.tuprolog.Prolog;
import alice.tuprolog.Theory;
import alice.tuprologx.ide.FrameLauncher;
import alice.tuprologx.ide.IDE;
import alice.tuprologx.ide.IOFileOperations;
import alice.tuprologx.ide.LibraryDialog;
import alice.util.thinlet.Thinlet;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ThinletToolBar
extends Thinlet {
    private Prolog engine;
    private Thinlet debugArea;
    private LibraryDialog libraryDialog;
    private IOFileOperations fileManager;
    private FrameLauncher frameLauncher;
    private String statusMessage;
    private PropertyChangeSupport propertyChangeSupport;
    private IDE ide;

    public ThinletToolBar(IDE iDE) {
        try {
            this.add(this.parse("xml/ThinletToolBar.xml"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.ide = iDE;
    }

    public Prolog getEngine() {
        return this.engine;
    }

    public void setEngine(Prolog prolog) {
        this.engine = prolog;
    }

    public void setStatusMessage(String string) {
        String string2 = this.getStatusMessage();
        this.statusMessage = string;
        this.propertyChangeSupport.firePropertyChange("StatusMessage", string2, this.statusMessage);
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setFileManager(IOFileOperations iOFileOperations) {
        this.fileManager = iOFileOperations;
    }

    public IOFileOperations getFileManager() {
        return this.fileManager;
    }

    public void setFrameLauncher(FrameLauncher frameLauncher) {
        this.frameLauncher = frameLauncher;
    }

    public FrameLauncher getFrameLauncher() {
        return this.frameLauncher;
    }

    protected void enableTheoryCommands(boolean bl) {
        Object object = this.find("newTheoryButton");
        this.setBoolean(object, "enabled", bl);
        Object object2 = this.find("loadTheoryButton");
        this.setBoolean(object2, "enabled", bl);
        Object object3 = this.find("saveTheoryButton");
        this.setBoolean(object3, "enabled", bl);
        Object object4 = this.find("saveTheoryAsButton");
        this.setBoolean(object4, "enabled", bl);
        Object object5 = this.find("openLibraryManagerButton");
        this.setBoolean(object5, "enabled", bl);
    }

    public void newTheory() {
        this.engine.clearTheory();
        this.ide.setEditorContent("");
        this.fileManager.resetDefaultTheoryFileName();
        this.setStatusMessage("Ready (new theory accepted).");
    }

    public void loadTheory() {
        this.setStatusMessage("Load Theory...");
        try {
            Theory theory = this.fileManager.loadTheory();
            if (theory != null) {
                this.engine.setTheory(theory);
                this.ide.setEditorContent(theory.toString());
                this.setStatusMessage("Ready (theory consulted).");
            } else {
                this.setStatusMessage("Ready.");
            }
        }
        catch (Exception exception) {
            this.setStatusMessage("Error consulting theory.");
        }
    }

    public void saveTheory() {
        try {
            String string = this.fileManager.saveTheory(this.ide.getEditorContent());
            this.setStatusMessage("Theory saved to " + string + ".");
        }
        catch (Exception exception) {
            this.setStatusMessage("Error saving theory.");
        }
    }

    public void saveTheoryAs() {
        this.setStatusMessage("Save Theory As...");
        try {
            String string = this.fileManager.saveTheoryAs(this.ide.getEditorContent());
            if (string != "") {
                this.setStatusMessage("Theory saved to " + string + ".");
            } else {
                this.setStatusMessage("Ready.");
            }
        }
        catch (Exception exception) {
            this.setStatusMessage("Error saving theory.");
        }
    }

    public void openLibraryManager() {
        this.frameLauncher.launchFrame(this.libraryDialog, "Library Manager", 275, 250);
    }

    public void viewDebugInformation() {
        this.frameLauncher.launchFrame(this.debugArea, "Debug Information", 200, 300);
    }

    public void viewAboutInformation() {
        Thinlet thinlet = new Thinlet();
        try {
            thinlet.add(this.parse("xml/AboutDialog.xml"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Object object = thinlet.find("tuPrologSystem");
        thinlet.setString(object, "text", "tuProlog System version " + Prolog.getVersion());
        this.frameLauncher.launchFrame(thinlet, "About tuProlog IDE", 270, 125);
    }

    public void setDebugArea(Thinlet thinlet) {
        this.debugArea = thinlet;
    }

    public Thinlet getDebugArea() {
        return this.debugArea;
    }

    public void setLibraryDialog(LibraryDialog libraryDialog) {
        this.libraryDialog = libraryDialog;
    }
}

